/*
 * Decompiled with CFR 0.152.
 */
package ibm.nways.jdm;

import ibm.nways.jdm.BrowserApplet;
import ibm.nways.jdm.HasStatusDependents;
import ibm.nways.jdm.I18NString;
import ibm.nways.jdm.JmaColors;
import ibm.nways.jdm.Status;
import ibm.nways.jdm.eui.MultiLineLabel;
import java.awt.Button;
import java.awt.Component;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.Label;
import java.awt.List;
import java.awt.Rectangle;
import java.awt.ScrollPane;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.util.Enumeration;
import java.util.Locale;
import java.util.ResourceBundle;
import java.util.Vector;

class CompStatExplain
extends Dialog
implements ActionListener,
ItemListener {
    private BrowserApplet browser;
    Status stat;
    private GridBagLayout gbl;
    private Label compStatLabel;
    private Label compStatValue;
    private Label policyLabel;
    private Label policyValue;
    private Label explainLabel;
    private Explain explainArea;
    private Label dependLabel;
    private List dependList;
    private Label explainDepLabel;
    private Explain explainDepArea;
    private ScrollPane explainDepScroller;
    private Vector statusItems;
    private Vector textItems;
    private Button explItemButton;
    private Status selectedDepStatus;
    private ResourceBundle myResources = ResourceBundle.getBundle("ibm.nways.jdm.CompStatExplainResources", Locale.getDefault());
    private Button cancelButton;

    public CompStatExplain(BrowserApplet browserApplet, Status status) {
        super(browserApplet.getFrame(), false);
        this.browser = browserApplet;
        this.stat = status;
        ((Component)this).setBackground(browserApplet.getBackground());
        this.setForeground(browserApplet.getForeground());
        this.gbl = new GridBagLayout();
        this.setLayout(this.gbl);
        I18NString i18NString = status.getName();
        String string = i18NString == null ? this.myResources.getString("noStatusName") : i18NString.getTranslation();
        this.setTitle(String.valueOf(string) + this.myResources.getString("titleTail"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        this.compStatLabel = new Label(this.myResources.getString("compStatLabel"));
        this.compStatLabel.setForeground(JmaColors.textText);
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 4;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        gridBagConstraints.anchor = 13;
        this.gbl.setConstraints(this.compStatLabel, gridBagConstraints);
        this.compStatValue = new Label();
        this.compStatValue.setForeground(JmaColors.textText);
        gridBagConstraints.gridx = 4;
        gridBagConstraints.anchor = 17;
        this.gbl.setConstraints(this.compStatValue, gridBagConstraints);
        if (status instanceof HasStatusDependents) {
            this.policyLabel = new Label(this.myResources.getString("policyLabel"));
            this.policyLabel.setForeground(JmaColors.textText);
            ++gridBagConstraints.gridy;
            gridBagConstraints.gridx = 0;
            gridBagConstraints.anchor = 13;
            this.gbl.setConstraints(this.policyLabel, gridBagConstraints);
            this.policyValue = new Label();
            this.policyValue.setForeground(JmaColors.textText);
            gridBagConstraints.gridx = 4;
            gridBagConstraints.anchor = 17;
            this.gbl.setConstraints(this.policyValue, gridBagConstraints);
        }
        this.explainLabel = new Label(this.myResources.getString("compExpl"));
        this.explainLabel.setForeground(JmaColors.textText);
        gridBagConstraints.gridx = 0;
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridwidth = 8;
        this.gbl.setConstraints(this.explainLabel, gridBagConstraints);
        this.explainArea = new Explain("", 10, 10);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.fill = 1;
        this.gbl.setConstraints(this.explainArea, gridBagConstraints);
        this.dependLabel = new Label(this.myResources.getString("selectDep"));
        this.dependLabel.setForeground(JmaColors.textText);
        gridBagConstraints.gridy += 2;
        gridBagConstraints.gridheight = 1;
        this.gbl.setConstraints(this.dependLabel, gridBagConstraints);
        this.initDependents();
        this.dependList = new List(this.textItems.size());
        this.dependList.setMultipleMode(false);
        this.dependList.addItemListener(this);
        this.dependList.setBackground(browserApplet.getBackground());
        Enumeration enumeration = this.textItems.elements();
        while (enumeration.hasMoreElements()) {
            this.dependList.add((String)enumeration.nextElement());
        }
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 3;
        gridBagConstraints.weighty = 1.0;
        this.gbl.setConstraints(this.dependList, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        this.explainDepLabel = new Label(this.myResources.getString("dependExpl"));
        this.explainDepLabel.setForeground(JmaColors.textText);
        gridBagConstraints.gridy += 3;
        gridBagConstraints.gridheight = 1;
        this.gbl.setConstraints(this.explainDepLabel, gridBagConstraints);
        this.explainDepArea = new Explain("", 15, 10);
        this.explainDepScroller = new ScrollPane();
        this.explainDepScroller.add(this.explainDepArea);
        this.explainDepScroller.setVisible(false);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridheight = 2;
        gridBagConstraints.weighty = 1.0;
        this.gbl.setConstraints(this.explainDepScroller, gridBagConstraints);
        gridBagConstraints.weighty = 0.0;
        this.explItemButton = new Button(this.myResources.getString("explainItemButton"));
        this.explItemButton.setForeground(SystemColor.controlText);
        this.explItemButton.setBackground(SystemColor.control);
        this.explItemButton.setActionCommand("explainItemButton");
        this.explItemButton.addActionListener(this);
        this.explItemButton.setEnabled(false);
        gridBagConstraints.gridy += 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridwidth = 8;
        gridBagConstraints.insets = new Insets(10, 10, 10, 10);
        gridBagConstraints.anchor = 10;
        this.gbl.setConstraints(this.explItemButton, gridBagConstraints);
        this.update();
        this.cancelButton = new Button(this.myResources.getString("cancelButton"));
        this.cancelButton.setForeground(SystemColor.controlText);
        this.cancelButton.setBackground(SystemColor.control);
        this.cancelButton.setActionCommand("cancelButton");
        this.cancelButton.addActionListener(this);
        ++gridBagConstraints.gridy;
        gridBagConstraints.gridx = 0;
        this.gbl.setConstraints(this.cancelButton, gridBagConstraints);
        this.add(this.cancelButton);
        this.addWindowListener(new CloseWindowHandler());
        this.add(this.compStatLabel);
        this.add(this.compStatValue);
        if (this.policyLabel != null) {
            this.add(this.policyLabel);
            this.add(this.policyValue);
        }
        this.add(this.explainLabel);
        this.add(this.explainArea);
        this.add(this.dependLabel);
        this.add(this.dependList);
        this.add(this.explainDepLabel);
        this.add(this.explainDepScroller);
        this.add(this.explItemButton);
        this.doLayout();
        ((Component)this).setSize(400, 500);
    }

    public Insets getInsets() {
        return new Insets(40, 20, 20, 20);
    }

    public void actionPerformed(ActionEvent actionEvent) {
        if (actionEvent.getActionCommand().equals("cancelButton")) {
            this.close();
            return;
        }
        if (actionEvent.getActionCommand().equals("explainItemButton") && this.selectedDepStatus instanceof HasStatusDependents) {
            CompStatExplain compStatExplain = new CompStatExplain(this.browser, this.selectedDepStatus);
            compStatExplain.show();
        }
    }

    public void close() {
        this.dispose();
    }

    public void itemStateChanged(ItemEvent itemEvent) {
        if (itemEvent.getStateChange() == 1) {
            this.selectedDepStatus = (Status)this.statusItems.elementAt((Integer)itemEvent.getItem());
            String string = null;
            I18NString i18NString = this.selectedDepStatus.getExplanation();
            if (i18NString != null) {
                string = i18NString.getTranslation();
            }
            if (string == null || string.length() == 0) {
                string = this.myResources.getString("noExpl");
            }
            this.explainDepArea.setText(string);
            this.explainDepScroller.setVisible(false);
            Rectangle rectangle = this.explainDepScroller.getBounds();
            this.explainDepScroller.setBounds(rectangle.x, rectangle.y, rectangle.width - 3, rectangle.height - 3);
            this.explainDepScroller.invalidate();
            this.explainDepScroller.validate();
            this.explainDepScroller.setVisible(true);
            if (this.selectedDepStatus instanceof HasStatusDependents) {
                this.explItemButton.setEnabled(true);
            } else {
                this.explItemButton.setEnabled(false);
            }
            this.invalidate();
            this.validate();
        }
    }

    private void initDependents() {
        this.statusItems = new Vector();
        this.textItems = new Vector();
        Enumeration enumeration = ((HasStatusDependents)((Object)this.stat)).getDependents().elements();
        while (enumeration.hasMoreElements()) {
            Status status = (Status)enumeration.nextElement();
            I18NString i18NString = status.getName();
            String string = i18NString == null ? this.myResources.getString("noStatusName") : i18NString.getTranslation();
            String string2 = String.valueOf(string) + ": " + status.getStatusType().toString();
            this.textItems.addElement(string2);
            this.statusItems.addElement(status);
        }
    }

    private void update() {
        Object object;
        this.compStatValue.setText(this.stat.getStatusType().toString());
        if (this.stat instanceof HasStatusDependents) {
            object = (HasStatusDependents)((Object)this.stat);
            this.policyValue.setText(object.getManagerLabel(Locale.getDefault()));
        }
        object = null;
        I18NString i18NString = this.stat.getExplanation();
        if (i18NString != null) {
            object = i18NString.getTranslation();
        }
        if (object == null || ((String)object).length() == 0) {
            object = this.myResources.getString("noExpl");
        }
        this.explainArea.setText((String)object);
    }

    private class CloseWindowHandler
    extends WindowAdapter {
        public void windowClosing(WindowEvent windowEvent) {
            CompStatExplain.this.close();
        }

        CloseWindowHandler() {
            CompStatExplain.this = CompStatExplain.this;
        }
    }

    class Explain
    extends MultiLineLabel {
        public Explain(String string, int n, int n2) {
            super(string, n, n2);
            CompStatExplain.this = CompStatExplain.this;
        }

        public Dimension getMinimumSize() {
            return new Dimension(this.max_width, 2 * this.line_height);
        }
    }

    class DepList
    extends List {
        DepList() {
            CompStatExplain.this = CompStatExplain.this;
        }
    }
}

